#include "CommandTable.h"
#include "Hooks_DirectInput8Create.h"
#include "Hooks_SaveLoad.h"
#include "Hooks_Editor.h"
#include "SafeWrite.h"
#include "Utilities.h"

#if RUNTIME
IDebugLog	gLog("nvse.log");

STATIC_ASSERT(RUNTIME_VERSION == RUNTIME_VERSION_1_3_0_452);
#else
IDebugLog	gLog("nvse_editor.log");

STATIC_ASSERT(EDITOR_VERSION == CS_VERSION_1_3_0_452);
#endif

void WaitForDebugger(void)
{
	while(!IsDebuggerPresent())
	{
		Sleep(10);
	}

	Sleep(1000 * 2);
}

// fix dinput code so it doesn't acquire the keyboard/mouse in exclusive mode
// bBackground Mouse works on startup, but when gaining focus that setting is ignored
// there's probably a better way to fix the bug but this is good enough
void PatchCoopLevel(void)
{
	SafeWrite8(0x00A1F871 + 1, 0x16);
	SafeWrite8(0x00A1FA9B + 1, 0x06);
	SafeWrite8(0x00A20D7D + 1, 0x06);
}

// fix render path selection
void PatchRenderPath(void)
{
	for(UInt32 i = 0; i < 6; i++)
		SafeWrite8(0x00B4CE8D + i, 0x90);	// nop

	//	0	none
	//	1	1x
	//	2	2
	//	3	2a (96)
	//	4	2b (96)
	//	5	2a
	//	6	2b
	//	7	3

	SafeWrite32(0x00B4CE93 + 6, 7);	// render path goes here
}

void NVSE_Initialize(void)
{
#ifndef _DEBUG
	__try {
#endif

#if RUNTIME
		_MESSAGE("NVSE runtime: initialize (version = %d.%d.%d %08X)", NVSE_VERSION_INTEGER, NVSE_VERSION_INTEGER_MINOR, NVSE_VERSION_INTEGER_BETA, RUNTIME_VERSION);
#else
		_MESSAGE("NVSE editor: initialize (version = %d.%d.%d %08X)", NVSE_VERSION_INTEGER, NVSE_VERSION_INTEGER_MINOR, NVSE_VERSION_INTEGER_BETA, EDITOR_VERSION);
#endif
		_MESSAGE("imagebase = %08X", GetModuleHandle(NULL));

#ifdef _DEBUG
		SetPriorityClass(GetCurrentProcess(), IDLE_PRIORITY_CLASS);

#if RUNTIME
		PatchCoopLevel();
#endif

//		WaitForDebugger();
#endif

//		PatchRenderPath();

		MersenneTwister::init_genrand(GetTickCount());
		CommandTable::Init();

#if RUNTIME
		Hook_DirectInput8Create_Init();
		Hook_SaveLoad_Init();
#endif

#if EDITOR
		Hook_Editor_Init();
#endif

		FlushInstructionCache(GetCurrentProcess(), NULL, 0);

#ifndef _DEBUG
	}
	__except(EXCEPTION_EXECUTE_HANDLER)
	{
		_ERROR("exception");
	}
#endif

	_MESSAGE("init complete");
}

void NVSE_DeInitialize(void)
{
	//
}

extern "C" {

void StartNVSE(void)
{
	NVSE_Initialize();
}

BOOL WINAPI DllMain(HANDLE hDllHandle, DWORD dwReason, LPVOID lpreserved)
{
	switch(dwReason)
	{
		case DLL_PROCESS_ATTACH:
			NVSE_Initialize();
			break;

		case DLL_PROCESS_DETACH:
			NVSE_DeInitialize();
			break;
	};

	return TRUE;
}

};
