#pragma once

#include <vector>

class TESObjectREFR;
class Script;
struct ScriptEventList;
class ScriptLineBuffer;
class ScriptBuffer;

// for IsInventoryObjectType list, see GameForms.h

enum ParamType
{
	kParamType_String =					0x00,
	kParamType_Integer =				0x01,
	kParamType_Float =					0x02,
	kParamType_ObjectID =				0x03,	// GetItemCount				TESForm *, must pass IsInventoryObjectType and TESForm::Unk_3A
	kParamType_ObjectRef =				0x04,	// Activate					TESObjectREFR *, REFR-PFLA
	kParamType_ActorValue =				0x05,	// ModActorValue			UInt32 *, immediate UInt16
	kParamType_Actor =					0x06,	// ToggleAI					TESObjectREFR *, must pass IsActor (ACHR-ACRE)
	kParamType_SpellItem =				0x07,	// AddSpell					TESForm *, must be either SpellItem or book
	kParamType_Axis =					0x08,	// Rotate					char *, immediate char, X Y Z
	kParamType_Cell =					0x09,	// GetInCell				TESObjectCELL *, must be cell
	kParamType_AnimationGroup =			0x0A,	// PlayGroup				UInt32 *, immediate UInt16
	kParamType_MagicItem =				0x0B,	// Cast						MagicItem *
	kParamType_Sound =					0x0C,	// Sound					TESForm *, kFormType_Sound
	kParamType_Topic =					0x0D,	// Say						TESForm *, kFormType_Dialog
	kParamType_Quest =					0x0E,	// ShowQuestVars			TESForm *, kFormType_Quest
	kParamType_Race =					0x0F,	// GetIsRace				TESForm *, kFormType_Race
	kParamType_Class =					0x10,	// GetIsClass				TESForm *, kFormType_Class
	kParamType_Faction =				0x11,	// Faction					TESForm *, kFormType_Faction
	kParamType_Sex =					0x12,	// GetIsSex					UInt32 *, immediate UInt16
	kParamType_Global =					0x13,	// GetGlobalValue			TESForm *, kFormType_Global
	kParamType_Furniture =				0x14,	// IsCurrentFurnitureObj	TESForm *, kFormType_Furniture or kFormType_ListForm
	kParamType_TESObject =				0x15,	// PlaceAtMe				TESObject *, must pass TESForm::Unk_3A
	kParamType_VariableName =			0x16,	// GetQuestVariable			not sure how this is handled
	kParamType_QuestStage =				0x17,	// SetStage					handled like integer
	kParamType_MapMarker =				0x18,	// ShowMap					TESObjectREFR *, see ObjectRef
	kParamType_ActorBase =				0x19,	// SetEssential				TESActorBase * (NPC / creature)
	kParamType_Container =				0x1A,	// RemoveMe					TESObjectREFR *, see ObjectRef
	kParamType_WorldSpace =				0x1B,	// CenterOnWorld			TESWorldSpace *, kFormType_WorldSpace
	kParamType_CrimeType =				0x1C,	// GetCrimeKnown			UInt32 *, immediate UInt16
	kParamType_AIPackage =				0x1D,	// GetIsCurrentPackage		TESPackage *, kFormType_Package
	kParamType_CombatStyle =			0x1E,	// SetCombatStyle			TESCombatStyle *, kFormType_CombatStyle
	kParamType_MagicEffect =			0x1F,	// HasMagicEffect			EffectSetting *
	kParamType_FormType =				0x20,	// GetIsUsedItemType		UInt8 *, immediate UInt16
	kParamType_WeatherID =				0x21,	// GetIsCurrentWeather		TESForm *, kFormType_Weather
	kParamType_NPC =					0x22,	// unused					TESNPC *, kFormType_NPC
	kParamType_Owner =					0x23,	// IsOwner					TESForm *, kFormType_NPC or kFormType_Faction
	kParamType_EffectShader =			0x24,	// PlayMagicShaderVisuals	TESForm *, kFormType_EffectShader
	kParamType_FormList	=				0x25,	// IsInList					kFormType_ListForm
	kParamType_MenuIcon =				0x26,	// unused					kFormType_MenuIcon
	kParamType_Perk =					0x27,	// Add Perk					kFormType_Perk
	kParamType_Note =					0x28,	// Add Note					kFormType_Note
	kParamType_MiscellaneousStat =		0x29,	// ModPCMiscStat			UInt32 *, immediate UInt16
	kParamType_ImageSpaceModifier =		0x2A,	//							kFormType_ImageSpaceModifier
	kParamType_ImageSpace =				0x2B,	//							kFormType_ImageSpace
	kParamType_Unhandled2C =			0x2C,	// 
	kParamType_Unhandled2D =			0x2D,	// 
	kParamType_Unhandled2E =			0x2E,	// 
	kParamType_EncounterZone =			0x2F,	//							kFormType_EncounterZone
	kParamType_Unhandled30 =			0x30,	// 
	kParamType_Message =				0x31,	//							kFormType_Message
	kParamType_InvObjOrFormList =		0x32,	// AddItem					IsInventoryObjectType or kFormType_ListForm
	kParamType_Alignment =				0x33,	// GetIsAlignment			UInt32 *, immediate UInt16
	kParamType_EquipType =				0x34,	// GetIsUsedEquipType		UInt32 *, immediate UInt16
	kParamType_NonFormList =			0x35,	// GetIsUsedItem			TESForm::Unk_3A and not kFormType_ListForm
	kParamType_SoundFile =				0x36,	// PlayMusic				kFormType_SoundFile
	kParamType_CriticalStage =			0x37,	// SetCriticalStage			UInt32 *, immediate UInt16

	// added for dlc (1.1)
	kParamType_LeveledOrBaseChar =		0x38,	// AddNPCToLeveledList		NPC / LeveledCharacter
	kParamType_LeveledOrBaseCreature =	0x39,	// AddCreatureToLeveledList	Creature / LeveledCreature
	kParamType_LeveledChar =			0x3A,	// AddNPCToLeveledList		kFormType_LeveledCharacter
	kParamType_LeveledCreature =		0x3B,	// AddCreatureToLeveledList	kFormType_LeveledCreature
	kParamType_LeveledItem =			0x3C,	// AddItemToLeveledList		kFormType_LeveledItem
	kParamType_AnyForm =				0x3D,	// AddFormToFormList		any form

	// new vegas
	kParamType_Reputation =				0x3E,	//							kFormType_Reputation
	kParamType_Casino =					0x3F,	//							kFormType_Casino
	kParamType_CasinoChip =				0x40,	//							kFormType_CasinoChip
	kParamType_Challenge =				0x41,	//							kFormType_Challenge
	kParamType_CaravanMoney =			0x42,	//							kFormType_CaravanMoney
	kParamType_CaravanCard =			0x43,	//							kFormType_CaravanCard
	kParamType_CaravanDeck =			0x44,	//							kFormType_CaravanDeck
	kParamType_Region =					0x45,	//							kFormType_Region
};


enum CommandReturnType : UInt8
{
	kRetnType_Default,
	kRetnType_Form,
	kRetnType_String,
	kRetnType_Array,
	kRetnType_ArrayIndex,
	kRetnType_Ambiguous,

	kRetnType_Max
};

struct ParamInfo
{
	const char	* typeStr;
	UInt32		typeID;		// ParamType
	UInt32		isOptional;	// do other bits do things?
};

#define COMMAND_ARGS		ParamInfo * paramInfo, void * scriptData, TESObjectREFR * thisObj, TESObjectREFR * containingObj, Script * scriptObj, ScriptEventList * eventList, double * result, UInt32 * opcodeOffsetPtr
#define PASS_COMMAND_ARGS	paramInfo, scriptData, thisObj, containingObj, scriptObj, eventList, result, opcodeOffsetPtr
#define EXTRACT_ARGS		paramInfo, scriptData, opcodeOffsetPtr, thisObj, containingObj, scriptObj, eventList
#define COMMAND_ARGS_EVAL	TESObjectREFR * thisObj, void * arg1, void * arg2, double * result
#define EXTRACT_ARGS_EX		paramInfo, scriptData, opcodeOffsetPtr, scriptObj, eventList

//Macro to make CommandInfo definitions a bit less tedious

#define DEFINE_CMD_FULL(name, altName, description, refRequired, numParams, paramInfo, parser) \
	extern bool Cmd_ ## name ## _Execute(COMMAND_ARGS); \
	static CommandInfo (kCommandInfo_ ## name) = { \
	#name, \
	#altName, \
	0, \
	#description, \
	refRequired, \
	numParams, \
	paramInfo, \
	HANDLER(Cmd_ ## name ## _Execute), \
	parser, \
	NULL, \
	0 \
	};

#define DEFINE_CMD_ALT(name, altName, description, refRequired, numParams, paramInfo) \
	DEFINE_CMD_FULL(name, altName, description, refRequired, numParams, paramInfo, Cmd_Default_Parse)	

#define DEFINE_COMMAND(name, description, refRequired, numParams, paramInfo) \
	DEFINE_CMD_FULL(name, , description, refRequired, numParams, paramInfo, Cmd_Default_Parse)	

#define DEFINE_COMMAND_PLUGIN(name, description, refRequired, numParams, paramInfo) \
	DEFINE_CMD_FULL(name, , description, refRequired, numParams, paramInfo, NULL)

// for commands which can be used as conditionals
#define DEFINE_CMD_COND(name, description, refRequired, paramInfo) \
	extern bool Cmd_ ## name ## _Execute(COMMAND_ARGS); \
	extern bool Cmd_ ## name ## _Eval(COMMAND_ARGS_EVAL); \
	static CommandInfo (kCommandInfo_ ## name) = { \
	#name,	\
	"",		\
	0,		\
	#description,	\
	refRequired,	\
	(sizeof(paramInfo) / sizeof(ParamInfo)),	\
	paramInfo,	\
	HANDLER(Cmd_ ## name ## _Execute),	\
	Cmd_Default_Parse,	\
	HANDLER_EVAL(Cmd_ ## name ## _Eval),	\
	1	\
	};

typedef bool (* Cmd_Execute)(COMMAND_ARGS);
bool Cmd_Default_Execute(COMMAND_ARGS);

typedef bool (* Cmd_Parse)(UInt32 numParams, ParamInfo * paramInfo, ScriptLineBuffer * lineBuf, ScriptBuffer * scriptBuf);
bool Cmd_Default_Parse(UInt32 numParams, ParamInfo * paramInfo, ScriptLineBuffer * lineBuf, ScriptBuffer * scriptBuf);

typedef bool (* Cmd_Eval)(COMMAND_ARGS_EVAL);
bool Cmd_Default_Eval(COMMAND_ARGS_EVAL);


#ifdef RUNTIME
#define HANDLER(x)	x
#define HANDLER_EVAL(x)	x
#else
#define HANDLER(x)	Cmd_Default_Execute
#define HANDLER_EVAL(x)	Cmd_Default_Eval
#endif

struct CommandInfo
{
	const char	* longName;		// 00
	const char	* shortName;	// 04
	UInt32		opcode;			// 08
	const char	* helpText;		// 0C
	UInt16		needsParent;	// 10
	UInt16		numParams;		// 12
	ParamInfo	* params;		// 14

	// handlers
	Cmd_Execute	execute;		// 18
	Cmd_Parse	parse;			// 1C
	Cmd_Eval	eval;			// 20

	UInt32		flags;			// 24

	void	DumpFunctionDef() const;
	void	DumpDocs() const;
};

const UInt32 kNVSEOpcodeStart = 0x1400;

struct CommandMetadata
{
	CommandMetadata() :parentPlugin(kNVSEOpcodeStart), returnType(kRetnType_Default) { }

	UInt32				parentPlugin;
	CommandReturnType	returnType;
};

class CommandTable
{
public:
	CommandTable();
	~CommandTable();

	static void	Init(void);

	void	Read(CommandInfo * start, CommandInfo * end);
	void	Add(CommandInfo * info, CommandReturnType retnType = kRetnType_Default, UInt32 parentPluginOpcodeBase = 0);
	void	PadTo(UInt32 id, CommandInfo * info = NULL);

	CommandInfo *	GetStart(void)	{ return &m_commands[0]; }
	CommandInfo *	GetEnd(void)	{ return GetStart() + m_commands.size(); }
	CommandInfo *	CommandTable::GetByName(const char * name);

	void	SetBaseID(UInt32 id)	{ m_baseID = id; m_curID = id; }
	UInt32	GetMaxID(void)			{ return m_baseID + m_commands.size(); }
	void	SetCurID(UInt32 id)		{ m_curID = id; }
	UInt32	GetCurID(void)			{ return m_curID; }

	void	Dump(void);
	void	DumpAlternateCommandNames(void);
	void	DumpCommandDocumentation(UInt32 startWithID = kNVSEOpcodeStart);

private:
	// add commands for each release (will help keep track of commands)
	void AddCommandsV1();
	void AddDebugCommands();

	typedef std::vector <CommandInfo>			CommandList;
	typedef std::map <UInt32, CommandMetadata>	CmdMetadataList;

	CommandList		m_commands;
	CmdMetadataList	m_metadata;

	UInt32		m_baseID;
	UInt32		m_curID;
};

extern CommandTable	g_consoleCommands;
extern CommandTable g_scriptCommands;
